#!/usr/bin/perl 

my @lines = <DATA>;
my %ident;
foreach my $line (@lines)
{
	chop $line;
	my $id = $line;
	$id = substr ($id, 5);
	$id =~ s/\.[^\.]+$//;
	$ident{$id} = [] unless exists $ident{$id};
	push @{$ident{$id}}, "cp $line ./dupes\n";
}

while (my ($id, $list) = each %ident)
{
	if (@$list > 1)
	{
		print join ('', @$list);
	}
}


__DATA__
D061_AP880911-0016.B.txt
D061_AP880911-0016.I.txt
D061_AP880912-0095.B.txt
D061_AP880912-0095.I.txt
D061_AP880912-0137.B.txt
D061_AP880912-0137.I.txt
D061_AP880915-0003.B.txt
D061_AP880915-0003.I.txt
D061_AP880916-0060.B.txt
D061_AP880916-0060.I.txt
D061_WSJ880912-0064.B.txt
D061_WSJ880912-0064.I.txt
D062_AP891018-0301.A.txt
D062_AP891018-0301.G.txt
D062_LA102089-0177.A.txt
D062_LA102089-0177.G.txt
D062_LA102489-0131.A.txt
D062_LA102489-0131.G.txt
D062_WSJ891019-0021.A.txt
D062_WSJ891019-0021.G.txt
D062_WSJ891019-0086.A.txt
D062_WSJ891019-0086.G.txt
D063_AP890922-0071.C.txt
D063_AP890922-0071.E.txt
D063_AP890922-0103.C.txt
D063_AP890922-0103.E.txt
D063_AP890922-0117.C.txt
D063_AP890922-0117.E.txt
D063_AP890923-0012.C.txt
D063_AP890923-0012.E.txt
D063_AP890923-0091.C.txt
D063_AP890923-0091.E.txt
D063_AP890924-0025.C.txt
D063_AP890924-0025.E.txt
D063_AP890925-0124.C.txt
D063_AP890925-0124.E.txt
D063_LA092389-0092.C.txt
D063_LA092389-0092.E.txt
D064_AP880314-0110.B.txt
D064_AP880314-0110.E.txt
D064_AP880324-0193.B.txt
D064_AP880324-0193.E.txt
D064_AP900131-0200.B.txt
D064_AP900131-0200.E.txt
D064_AP901008-0136.B.txt
D064_AP901008-0136.E.txt
D064_FT932-5869.B.txt
D064_FT932-5869.E.txt
D064_LA020190-0038.B.txt
D064_LA020190-0038.E.txt
D064_WSJ880412-0015.B.txt
D064_WSJ880412-0015.E.txt
D065_AP880817-0040.F.txt
D065_AP880817-0040.H.txt
D065_AP880818-0023.F.txt
D065_AP880818-0023.H.txt
D065_AP880818-0226.F.txt
D065_AP880818-0226.H.txt
D065_AP880819-0023.F.txt
D065_AP880819-0023.H.txt
D065_AP880826-0226.F.txt
D065_AP880826-0226.H.txt
D065_AP881114-0006.F.txt
D065_AP881114-0006.H.txt
D065_LA111289-0035.F.txt
D065_LA111289-0035.H.txt
D065_SJMN91-06140099.F.txt
D065_SJMN91-06140099.H.txt
D066_AP890323-0234.C.txt
D066_AP890323-0234.I.txt
D066_AP890615-0263.C.txt
D066_AP890615-0263.I.txt
D066_AP890711-0223.C.txt
D066_AP890711-0223.I.txt
D066_AP900507-0207.C.txt
D066_AP900507-0207.I.txt
D066_FT922-14265.C.txt
D066_FT922-14265.I.txt
D066_FT923-5068.C.txt
D066_FT923-5068.I.txt
D066_FT944-12170.C.txt
D066_FT944-12170.I.txt
D067_FT923-5589.A.txt
D067_FT923-5589.I.txt
D067_FT923-5797.A.txt
D067_FT923-5797.I.txt
D067_FT923-5835.A.txt
D067_FT923-5835.I.txt
D067_FT923-6038.A.txt
D067_FT923-6038.I.txt
D067_FT923-6110.A.txt
D067_FT923-6110.I.txt
D067_FT923-6455.A.txt
D067_FT923-6455.I.txt
D068_AP900621-0192.A.txt
D068_AP900621-0192.E.txt
D068_AP900622-0080.A.txt
D068_AP900622-0080.E.txt
D068_AP900622-0087.A.txt
D068_AP900622-0087.E.txt
D068_AP900623-0009.A.txt
D068_AP900623-0009.E.txt
D068_LA062290-0172.A.txt
D068_LA062290-0172.E.txt
D069_AP890925-0009.B.txt
D069_AP890925-0009.C.txt
D069_AP891111-0064.B.txt
D069_AP891111-0064.C.txt
D069_AP891202-0154.B.txt
D069_AP891202-0154.C.txt
D069_AP891207-0158.B.txt
D069_AP891207-0158.C.txt
D069_AP891212-0062.B.txt
D069_AP891212-0062.C.txt
D069_AP900130-0202.B.txt
D069_AP900130-0202.C.txt
D069_AP900131-0068.B.txt
D069_AP900131-0068.C.txt
D069_AP900210-0106.B.txt
D069_AP900210-0106.C.txt
D069_AP900214-0157.B.txt
D069_AP900214-0157.C.txt
D069_AP900215-0013.B.txt
D069_AP900215-0013.C.txt
D069_AP900321-0057.B.txt
D069_AP900321-0057.C.txt
D069_FT923-6509.B.txt
D069_FT923-6509.C.txt
D069_LA021290-0043.B.txt
D069_LA021290-0043.C.txt
D069_WSJ890922-0113.B.txt
D069_WSJ890922-0113.C.txt
D070_AP900103-0077.D.txt
D070_AP900103-0077.G.txt
D070_AP900118-0029.D.txt
D070_AP900118-0029.G.txt
D070_AP900129-0036.D.txt
D070_AP900129-0036.G.txt
D070_AP900129-0071.D.txt
D070_AP900129-0071.G.txt
D070_AP900730-0116.D.txt
D070_AP900730-0116.G.txt
D070_AP900810-0120.D.txt
D070_AP900810-0120.G.txt
D070_AP900825-0099.D.txt
D070_AP900825-0099.G.txt
D070_AP900919-0122.D.txt
D070_AP900919-0122.G.txt
D070_AP901208-0106.D.txt
D070_AP901208-0106.G.txt
D070_FBIS4-42178.D.txt
D070_FBIS4-42178.G.txt
D070_SJMN91-06353190.D.txt
D070_SJMN91-06353190.G.txt
D071_AP880310-0062.B.txt
D071_AP880310-0062.D.txt
D071_AP880917-0157.B.txt
D071_AP880917-0157.D.txt
D071_LA020489-0060.B.txt
D071_LA020489-0060.D.txt
D071_SJMN91-06044329.B.txt
D071_SJMN91-06044329.D.txt
D071_SJMN91-06058250.B.txt
D071_SJMN91-06058250.D.txt
D071_WSJ890726-0004.B.txt
D071_WSJ890726-0004.D.txt
D072_AP880622-0184.I.txt
D072_AP880622-0184.J.txt
D072_AP880720-0262.I.txt
D072_AP880720-0262.J.txt
D072_AP881115-0011.I.txt
D072_AP881115-0011.J.txt
D072_AP900716-0007.I.txt
D072_AP900716-0007.J.txt
D072_AP901010-0030.I.txt
D072_AP901010-0030.J.txt
D072_AP901016-0097.I.txt
D072_AP901016-0097.J.txt
D072_AP901019-0072.I.txt
D072_AP901019-0072.J.txt
D072_AP901114-0087.I.txt
D072_AP901114-0087.J.txt
D072_LA101590-0066.I.txt
D072_LA101590-0066.J.txt
D072_LA101990-0114.I.txt
D072_LA101990-0114.J.txt
D072_LA102090-0146.I.txt
D072_LA102090-0146.J.txt
D072_LA102690-0005.I.txt
D072_LA102690-0005.J.txt
D072_LA121490-0148.I.txt
D072_LA121490-0148.J.txt
D073_SJMN91-06162032.C.txt
D073_SJMN91-06162032.J.txt
D073_SJMN91-06163112.C.txt
D073_SJMN91-06163112.J.txt
D073_SJMN91-06164210.C.txt
D073_SJMN91-06164210.J.txt
D073_SJMN91-06165048.C.txt
D073_SJMN91-06165048.J.txt
D073_SJMN91-06167046.C.txt
D073_SJMN91-06167046.J.txt
D074_SJMN91-06255336.A.txt
D074_SJMN91-06255336.D.txt
D074_SJMN91-06255421.A.txt
D074_SJMN91-06255421.D.txt
D074_SJMN91-06255434.A.txt
D074_SJMN91-06255434.D.txt
D074_SJMN91-06256107.A.txt
D074_SJMN91-06256107.D.txt
D074_SJMN91-06256124.A.txt
D074_SJMN91-06256124.D.txt
D074_SJMN91-06261053.A.txt
D074_SJMN91-06261053.D.txt
D075_AP880428-0041.D.txt
D075_AP880428-0041.E.txt
D075_AP880818-0088.D.txt
D075_AP880818-0088.E.txt
D075_AP880829-0222.D.txt
D075_AP880829-0222.E.txt
D075_AP881115-0113.D.txt
D075_AP881115-0113.E.txt
D075_AP890115-0014.D.txt
D075_AP890115-0014.E.txt
D075_AP900322-0112.D.txt
D075_AP900322-0112.E.txt
D075_AP900705-0149.D.txt
D075_AP900705-0149.E.txt
D075_AP901003-0006.D.txt
D075_AP901003-0006.E.txt
D075_WSJ880603-0129.D.txt
D075_WSJ880603-0129.E.txt
D075_WSJ910418-0105.D.txt
D075_WSJ910418-0105.E.txt
D076_AP891106-0072.E.txt
D076_AP901122-0100.E.txt
D076_AP901123-0002.E.txt
D076_AP901123-0062.E.txt
D076_AP901126-0053.E.txt
D076_LA040689-0198.E.txt
D076_LA112090-0165.E.txt
D076_LA112190-0001.E.txt
D076_LA112390-0008.E.txt
D076_LA120890-0055.E.txt
D077_AP891017-0195.G.txt
D077_AP891017-0195.H.txt
D077_AP891017-0199.G.txt
D077_AP891017-0199.H.txt
D077_AP891017-0204.G.txt
D077_AP891017-0204.H.txt
D077_AP891018-0084.G.txt
D077_AP891018-0084.H.txt
D077_AP891019-0037.G.txt
D077_AP891019-0037.H.txt
D077_LA101889-0066.G.txt
D077_LA101889-0066.H.txt
D077_LA101889-0108.G.txt
D077_LA101889-0108.H.txt
D077_LA102089-0172.G.txt
D077_LA102089-0172.H.txt
D077_LA102089-0177.G.txt
D077_LA102089-0177.H.txt
D077_LA102389-0075.G.txt
D077_LA102389-0075.H.txt
D078_AP880217-0100.H.txt
D078_AP880217-0100.J.txt
D078_AP880325-0239.H.txt
D078_AP880325-0239.J.txt
D078_AP880328-0206.H.txt
D078_AP880328-0206.J.txt
D078_AP890323-0218.H.txt
D078_AP890323-0218.J.txt
D078_AP890324-0014.H.txt
D078_AP890324-0014.J.txt
D078_AP890330-0123.H.txt
D078_AP890330-0123.J.txt
D078_AP891110-0043.H.txt
D078_AP891110-0043.J.txt
D078_AP900220-0065.H.txt
D078_AP900220-0065.J.txt
D078_LA033089-0190.H.txt
D078_LA033089-0190.J.txt
D078_LA033189-0114.H.txt
D078_LA033189-0114.J.txt
D079_AP880911-0016.B.txt
D079_AP880911-0016.I.txt
D079_AP880914-0004.B.txt
D079_AP880914-0004.I.txt
D079_AP880914-0027.B.txt
D079_AP880914-0027.I.txt
D079_AP880914-0131.B.txt
D079_AP880914-0131.I.txt
D079_AP880915-0142.B.txt
D079_AP880915-0142.I.txt
D079_AP880916-0025.B.txt
D079_AP880916-0025.I.txt
D079_AP880917-0095.B.txt
D079_AP880917-0095.I.txt
D079_AP880917-0096.B.txt
D079_AP880917-0096.I.txt
D079_WSJ880912-0064.B.txt
D079_WSJ880912-0064.I.txt
D080_AP900117-0193.E.txt
D080_AP900117-0193.I.txt
D080_AP900118-0183.E.txt
D080_AP900118-0183.I.txt
D080_AP900118-0190.E.txt
D080_AP900118-0190.I.txt
D080_AP900118-0205.E.txt
D080_AP900118-0205.I.txt
D080_AP900119-0024.E.txt
D080_AP900119-0024.I.txt
D080_AP900119-0041.E.txt
D080_AP900119-0041.I.txt
D080_AP900119-0051.E.txt
D080_AP900119-0051.I.txt
D080_LA011990-0091.E.txt
D080_LA011990-0091.I.txt
D080_LA012090-0110.E.txt
D080_LA012090-0110.I.txt
D080_LA012190-0194.E.txt
D080_LA012190-0194.I.txt
D080_LA012290-0036.E.txt
D080_LA012290-0036.I.txt
D081_AP880816-0135.D.txt
D081_AP880816-0135.G.txt
D081_AP880817-0124.D.txt
D081_AP880817-0124.G.txt
D081_AP890616-0230.D.txt
D081_AP890616-0230.G.txt
D081_AP890719-0248.D.txt
D081_AP890719-0248.G.txt
D081_AP890720-0075.D.txt
D081_AP890720-0075.G.txt
D081_AP890721-0091.D.txt
D081_AP890721-0091.G.txt
D081_AP891103-0200.D.txt
D081_AP891103-0200.G.txt
D081_FBIS4-42027.D.txt
D081_FBIS4-42027.G.txt
D081_FT923-12122.D.txt
D081_FT923-12122.G.txt
D081_FT933-9536.D.txt
D081_FT933-9536.G.txt
D081_SJMN91-06069108.D.txt
D081_SJMN91-06069108.G.txt
D081_WSJ870804-0095.D.txt
D081_WSJ870804-0095.G.txt
D082_AP880512-0096.C.txt
D082_AP880512-0096.H.txt
D082_AP880512-0157.C.txt
D082_AP880512-0157.H.txt
D082_AP881109-0161.C.txt
D082_AP881109-0161.H.txt
D082_AP881110-0227.C.txt
D082_AP881110-0227.H.txt
D082_AP890320-0158.C.txt
D082_AP890320-0158.H.txt
D082_AP891216-0037.C.txt
D082_AP891216-0037.H.txt
D082_AP891217-0053.C.txt
D082_AP891217-0053.H.txt
D082_LA012189-0060.C.txt
D082_LA012189-0060.H.txt
D082_LA051589-0055.C.txt
D082_LA051589-0055.H.txt
D082_LA121589-0192.C.txt
D082_LA121589-0192.H.txt
D083_AP891115-0199.B.txt
D083_AP891115-0199.G.txt
D083_AP891116-0035.B.txt
D083_AP891116-0035.G.txt
D083_AP891116-0184.B.txt
D083_AP891116-0184.G.txt
D083_AP891116-0191.B.txt
D083_AP891116-0191.G.txt
D083_AP891116-0198.B.txt
D083_AP891116-0198.G.txt
D083_LA111689-0160.B.txt
D083_LA111689-0160.G.txt
D084_AP890420-0176.H.txt
D084_AP890420-0176.J.txt
D084_AP890421-0013.H.txt
D084_AP890421-0013.J.txt
D084_AP890421-0062.H.txt
D084_AP890421-0062.J.txt
D084_AP890421-0186.H.txt
D084_AP890421-0186.J.txt
D084_AP890422-0035.H.txt
D084_AP890422-0035.J.txt
D084_AP890423-0090.H.txt
D084_AP890423-0090.J.txt
D084_AP890424-0026.H.txt
D084_AP890424-0026.J.txt
D084_AP890425-0013.H.txt
D084_AP890425-0013.J.txt
D084_LA041989-0141.H.txt
D084_LA041989-0141.J.txt
D084_LA042389-0098.H.txt
D084_LA042389-0098.J.txt
D084_LA042489-0051.H.txt
D084_LA042489-0051.J.txt
D085_ WSJ890928-0084.H.txt
D085_AP890922-0007.A.txt
D085_AP890922-0007.H.txt
D085_AP890922-0049.A.txt
D085_AP890922-0049.H.txt
D085_AP890922-0072.A.txt
D085_AP890922-0072.H.txt
D085_AP890922-0167.A.txt
D085_AP890922-0167.H.txt
D085_AP890922-0193.A.txt
D085_AP890922-0193.H.txt
D085_AP890923-0035.A.txt
D085_AP890923-0035.H.txt
D085_AP890925-0054.A.txt
D085_AP890925-0054.H.txt
D085_LA092789-0093.A.txt
D085_LA092789-0093.H.txt
D085_WSJ890928-0084.A.txt
D086_AP900801-0004.A.txt
D086_AP900801-0004.B.txt
D086_AP900802-0057.A.txt
D086_AP900802-0057.B.txt
D086_AP900802-0077.A.txt
D086_AP900802-0077.B.txt
D086_AP900802-0135.A.txt
D086_AP900802-0135.B.txt
D086_AP900803-0004.A.txt
D086_AP900803-0004.B.txt
D086_AP900803-0008.A.txt
D086_AP900803-0008.B.txt
D086_AP900805-0019.A.txt
D086_AP900805-0019.B.txt
D086_AP900805-0060.A.txt
D086_AP900805-0060.B.txt
D086_LA080290-0233.A.txt
D086_LA080290-0233.B.txt
D086_LA080390-0085.A.txt
D086_LA080390-0085.B.txt
D086_LA080690-0111.A.txt
D086_LA080690-0111.B.txt
D087_AP880228-0013.B.txt
D087_AP880228-0013.F.txt
D087_AP880228-0097.B.txt
D087_AP880228-0097.F.txt
D087_AP880929-0042.B.txt
D087_AP880929-0042.F.txt
D087_AP881002-0048.B.txt
D087_AP881002-0048.F.txt
D087_AP881003-0066.B.txt
D087_AP881003-0066.F.txt
D087_AP900328-0128.B.txt
D087_AP900328-0128.F.txt
D087_FT923-8765.B.txt
D087_FT923-8765.F.txt
D087_LA040790-0121.B.txt
D087_LA040790-0121.F.txt
D087_LA082889-0067.B.txt
D087_LA082889-0067.F.txt
D087_WSJ881004-0111.B.txt
D087_WSJ881004-0111.F.txt
D089_AP891115-0199.G.txt
D089_AP891115-0199.I.txt
D089_AP891116-0035.G.txt
D089_AP891116-0035.I.txt
D089_AP891116-0115.G.txt
D089_AP891116-0115.I.txt
D089_AP891116-0133.G.txt
D089_AP891116-0133.I.txt
D089_AP891116-0184.G.txt
D089_AP891116-0184.I.txt
D089_AP891116-0191.G.txt
D089_AP891116-0191.I.txt
D089_AP891116-0198.G.txt
D089_AP891116-0198.I.txt
D089_AP891117-0002.G.txt
D089_AP891117-0002.I.txt
D089_AP891118-0136.G.txt
D089_AP891118-0136.I.txt
D089_LA111689-0160.G.txt
D089_LA111689-0160.I.txt
D090_ AP900408-0059.J.txt
D090_AP880625-0142.I.txt
D090_AP880625-0142.J.txt
D090_AP890519-0060.I.txt
D090_AP890519-0060.J.txt
D090_AP890519-0117.I.txt
D090_AP890519-0117.J.txt
D090_AP890710-0170.I.txt
D090_AP890710-0170.J.txt
D090_AP900408-0059.I.txt
D090_AP900829-0044.I.txt
D090_AP900829-0044.J.txt
D090_LA052089-0075.I.txt
D090_LA052089-0075.J.txt
D090_LA101390-0087.I.txt
D090_LA101390-0087.J.txt
D090_LA120189-0122.I.txt
D090_LA120189-0122.J.txt
D090_LA120389-0170.I.txt
D090_LA120389-0170.J.txt
D091_AP900615-0115.F.txt
D091_AP900615-0115.J.txt
D091_AP900615-0164.F.txt
D091_AP900615-0164.J.txt
D091_AP900616-0032.F.txt
D091_AP900616-0032.J.txt
D091_AP900616-0123.F.txt
D091_AP900616-0123.J.txt
D091_AP900618-0018.F.txt
D091_AP900618-0018.J.txt
D091_AP900618-0069.F.txt
D091_AP900618-0069.J.txt
D091_LA061590-0176.F.txt
D091_LA061590-0176.J.txt
D091_LA061890-0066.F.txt
D091_LA061890-0066.J.txt
D092_AP900621-0186.A.txt
D092_AP900621-0186.F.txt
D092_AP900622-0025.A.txt
D092_AP900622-0025.F.txt
D092_AP900623-0022.A.txt
D092_AP900623-0022.F.txt
D092_AP900624-0011.A.txt
D092_AP900624-0011.F.txt
D092_AP900625-0036.A.txt
D092_AP900625-0036.F.txt
D092_AP900626-0010.A.txt
D092_AP900626-0010.F.txt
D092_LA062290-0134.A.txt
D092_LA062290-0134.F.txt
D092_LA062290-0169.A.txt
D092_LA062290-0169.F.txt
D092_LA062390-0068.A.txt
D092_LA062390-0068.F.txt
D092_LA062590-0096.A.txt
D092_LA062590-0096.F.txt
D093_AP880808-0039.D.txt
D093_AP880808-0039.H.txt
D093_AP881027-0051.D.txt
D093_AP881027-0051.H.txt
D093_AP881218-0007.D.txt
D093_AP881218-0007.H.txt
D093_AP890102-0076.D.txt
D093_AP890102-0076.H.txt
D093_AP890103-0029.D.txt
D093_AP890103-0029.H.txt
D093_AP901222-0078.D.txt
D093_AP901222-0078.H.txt
D093_SJMN91-06064099.D.txt
D093_SJMN91-06064099.H.txt
D093_SJMN91-06351097.D.txt
D093_SJMN91-06351097.H.txt
D093_SJMN91-06351209.D.txt
D093_SJMN91-06351209.H.txt
D094_AP881020-0157.D.txt
D094_AP881020-0157.J.txt
D094_AP881118-0104.D.txt
D094_AP881118-0104.J.txt
D094_AP890107-0016.D.txt
D094_AP890107-0016.J.txt
D094_AP890107-0039.D.txt
D094_AP890107-0039.J.txt
D094_AP890107-0119.D.txt
D094_AP890107-0119.J.txt
D094_AP890112-0071.D.txt
D094_AP890112-0071.J.txt
D094_AP890224-0003.D.txt
D094_AP890224-0003.J.txt
D094_AP890821-0100.D.txt
D094_AP890821-0100.J.txt
D094_LA012289-0055.D.txt
D094_LA012289-0055.J.txt
D095_AP890117-0004.E.txt
D095_AP890117-0004.H.txt
D095_AP890117-0160.E.txt
D095_AP890117-0160.H.txt
D095_AP890118-0013.E.txt
D095_AP890118-0013.H.txt
D095_AP890118-0051.E.txt
D095_AP890118-0051.H.txt
D095_AP890118-0094.E.txt
D095_AP890118-0094.H.txt
D095_AP890119-0221.E.txt
D095_AP890119-0221.H.txt
D095_AP890121-0050.E.txt
D095_AP890121-0050.H.txt
D095_AP890121-0123.E.txt
D095_AP890121-0123.H.txt
D095_LA011889-0131.E.txt
D095_LA011889-0131.H.txt
D095_LA012189-0073.E.txt
D095_LA012189-0073.H.txt
D096_AP890122-0087.G.txt
D096_AP890122-0087.J.txt
D096_AP890203-0164.G.txt
D096_AP890203-0164.J.txt
D096_AP891117-0248.G.txt
D096_AP891117-0248.J.txt
D096_AP900128-0063.G.txt
D096_AP900128-0063.J.txt
D096_AP900130-0113.G.txt
D096_AP900130-0113.J.txt
D096_LA013090-0161.G.txt
D096_LA013090-0161.J.txt
D096_LA020890-0197.G.txt
D096_LA020890-0197.J.txt
D096_SJMN91-06025182.G.txt
D096_SJMN91-06025182.J.txt
D096_SJMN91-06025282.G.txt
D096_SJMN91-06025282.J.txt
D096_WSJ870122-0100.G.txt
D096_WSJ870122-0100.J.txt
D097_AP890922-0007.A.txt
D097_AP890922-0007.J.txt
D097_AP890922-0049.A.txt
D097_AP890922-0049.J.txt
D097_AP890922-0119.A.txt
D097_AP890922-0119.J.txt
D097_AP890922-0167.A.txt
D097_AP890922-0167.J.txt
D097_AP890925-0054.A.txt
D097_AP890925-0054.J.txt
D097_AP890928-0099.A.txt
D097_AP890928-0099.J.txt
D097_LA092189-0225.A.txt
D097_LA092189-0225.J.txt
D097_LA092789-0093.A.txt
D097_LA092789-0093.J.txt
D097_WSJ890927-0018.A.txt
D097_WSJ890927-0018.J.txt
D097_WSJ890928-0084.A.txt
D097_WSJ890928-0084.J.txt
D098_AP900421-0075.A.txt
D098_AP900424-0048.A.txt
D098_AP900424-0081.A.txt
D098_AP900424-0096.A.txt
D098_AP900425-0013.A.txt
D098_AP900425-0146.A.txt
D098_AP900425-0198.A.txt
D098_AP900426-0135.A.txt
D098_AP900426-0185.A.txt
D098_AP900427-0083.A.txt
D098_AP900427-0146.A.txt
D098_AP900428-0050.A.txt
D099_AP881106-0062.C.txt
D099_AP881106-0062.D.txt
D099_FT923-8766.C.txt
D099_FT923-8766.D.txt
D099_LA030290-0075.C.txt
D099_LA030290-0075.D.txt
D099_LA121090-0095.C.txt
D099_LA121090-0095.D.txt
D099_SJMN91-06105230.C.txt
D099_SJMN91-06105230.D.txt
D099_SJMN91-06171237.C.txt
D099_SJMN91-06171237.D.txt
D099_SJMN91-06312120.C.txt
D099_SJMN91-06312120.D.txt
D099_WSJ870220-0106.C.txt
D099_WSJ870220-0106.D.txt
D099_WSJ910326-0090.C.txt
D099_WSJ910326-0090.D.txt
D100_AP880808-0040.D.txt
D100_AP880808-0040.F.txt
D100_AP880915-0066.D.txt
D100_AP880915-0066.F.txt
D100_AP880921-0201.D.txt
D100_AP880921-0201.F.txt
D100_AP881001-0104.D.txt
D100_AP881001-0104.F.txt
D100_AP881007-0207.D.txt
D100_AP881007-0207.F.txt
D100_AP890119-0266.D.txt
D100_AP890119-0266.F.txt
D100_AP900505-0127.D.txt
D100_AP900505-0127.F.txt
D100_AP901009-0072.D.txt
D100_AP901009-0072.F.txt
D100_AP901009-0148.D.txt
D100_AP901009-0148.F.txt
D100_AP901009-0186.D.txt
D100_AP901009-0186.F.txt
D100_AP901121-0206.D.txt
D100_AP901121-0206.F.txt
D100_AP901121-0207.D.txt
D100_AP901121-0207.F.txt
D100_AP901208-0076.D.txt
D100_AP901208-0076.F.txt
D100_SJMN91-06231192.D.txt
D100_SJMN91-06231192.F.txt
D100_WSJ881021-0008.D.txt
D100_WSJ881021-0008.F.txt
D101_SJMN91-06234048.F.txt
D101_SJMN91-06234048.G.txt
D101_SJMN91-06234109.F.txt
D101_SJMN91-06234109.G.txt
D101_SJMN91-06234209.F.txt
D101_SJMN91-06234209.G.txt
D101_SJMN91-06235097.F.txt
D101_SJMN91-06235097.G.txt
D101_SJMN91-06235179.F.txt
D101_SJMN91-06235179.G.txt
D101_SJMN91-06235187.F.txt
D101_SJMN91-06235187.G.txt
D101_SJMN91-06236235.F.txt
D101_SJMN91-06236235.G.txt
D101_SJMN91-06236241.F.txt
D101_SJMN91-06236241.G.txt
D101_SJMN91-06237020.F.txt
D101_SJMN91-06237020.G.txt
D101_SJMN91-06238185.F.txt
D101_SJMN91-06238185.G.txt
D102_AP890426-0123.D.txt
D102_AP890426-0123.I.txt
D102_AP890426-0126.D.txt
D102_AP890426-0126.I.txt
D102_AP890426-0160.D.txt
D102_AP890426-0160.I.txt
D102_AP890426-0185.D.txt
D102_AP890426-0185.I.txt
D102_AP890426-0204.D.txt
D102_AP890426-0204.I.txt
D102_AP890427-0014.D.txt
D102_AP890427-0014.I.txt
D102_AP890427-0052.D.txt
D102_AP890427-0052.I.txt
D102_AP890427-0098.D.txt
D102_AP890427-0098.I.txt
D102_AP890509-0040.D.txt
D102_AP890509-0040.I.txt
D102_AP890913-0253.D.txt
D102_AP890913-0253.I.txt
D102_LA042689-0146.D.txt
D102_LA042689-0146.I.txt
D102_LA042789-0025.D.txt
D102_LA042789-0025.I.txt
D102_LA042789-0032.D.txt
D102_LA042789-0032.I.txt
D102_LA042789-0068.D.txt
D102_LA042789-0068.I.txt
D103_AP900621-0186.A.txt
D103_AP900621-0186.E.txt
D103_AP900622-0025.A.txt
D103_AP900622-0025.E.txt
D103_AP900623-0022.A.txt
D103_AP900623-0022.E.txt
D103_AP900623-0119.A.txt
D103_AP900623-0119.E.txt
D103_AP900624-0011.A.txt
D103_AP900624-0011.E.txt
D103_AP900625-0153.A.txt
D103_AP900625-0153.E.txt
D103_LA062290-0169.A.txt
D103_LA062290-0169.E.txt
D103_LA062390-0001.A.txt
D103_LA062390-0001.E.txt
D103_LA062490-0172.A.txt
D103_LA062490-0172.E.txt
D103_LA062690-0155.A.txt
D103_LA062690-0155.E.txt
D104_AP890603-0103.A.txt
D104_AP890603-0103.C.txt
D104_AP890603-0108.A.txt
D104_AP890603-0108.C.txt
D104_AP890603-0122.A.txt
D104_AP890603-0122.C.txt
D104_AP890603-0126.A.txt
D104_AP890603-0126.C.txt
D104_AP890606-0116.A.txt
D104_AP890606-0116.C.txt
D104_AP890607-0067.A.txt
D104_AP890607-0067.C.txt
D104_AP890608-0094.A.txt
D104_AP890608-0094.C.txt
D104_AP890609-0036.A.txt
D104_AP890609-0036.C.txt
D104_AP890609-0094.A.txt
D104_AP890609-0094.C.txt
D105_AP880729-0155.C.txt
D105_AP880729-0155.D.txt
D105_AP891213-0164.C.txt
D105_AP891213-0164.D.txt
D105_AP900613-0195.C.txt
D105_AP900613-0195.D.txt
D105_AP901230-0022.C.txt
D105_AP901230-0022.D.txt
D105_FBIS4-40244.C.txt
D105_FBIS4-40244.D.txt
D105_FBIS4-62505.C.txt
D105_FBIS4-62505.D.txt
D105_FT921-4937.C.txt
D105_FT921-4937.D.txt
D105_FT921-5959.C.txt
D105_FT921-5959.D.txt
D105_FT923-13244.C.txt
D105_FT923-13244.D.txt
D105_FT924-10185.C.txt
D105_FT924-10185.D.txt
D105_FT934-2439.C.txt
D105_FT934-2439.D.txt
D105_LA070289-0167.C.txt
D105_LA070289-0167.D.txt
D106_AP880508-0070.D.txt
D106_AP880508-0070.F.txt
D106_AP881113-0007.D.txt
D106_AP881113-0007.F.txt
D106_AP890118-0100.D.txt
D106_AP890118-0100.F.txt
D106_AP890717-0149.D.txt
D106_AP890717-0149.F.txt
D106_AP900609-0040.D.txt
D106_AP900609-0040.F.txt
D106_AP900620-0133.D.txt
D106_AP900620-0133.F.txt
D106_AP901006-0037.D.txt
D106_AP901006-0037.F.txt
D106_LA021190-0179.D.txt
D106_LA021190-0179.F.txt
D106_LA021190-0181.D.txt
D106_LA021190-0181.F.txt
D106_SJMN91-06145218.D.txt
D106_SJMN91-06145218.F.txt
D107_AP880711-0056.E.txt
D107_AP880711-0056.H.txt
D107_AP880711-0221.E.txt
D107_AP880711-0221.H.txt
D107_AP880712-0250.E.txt
D107_AP880712-0250.H.txt
D107_AP880713-0121.E.txt
D107_AP880713-0121.H.txt
D107_AP880713-0175.E.txt
D107_AP880713-0175.H.txt
D107_AP880714-0085.E.txt
D107_AP880714-0085.H.txt
D107_AP880714-0156.E.txt
D107_AP880714-0156.H.txt
D107_AP880715-0065.E.txt
D107_AP880715-0065.H.txt
D107_AP880716-0052.E.txt
D107_AP880716-0052.H.txt
D108_AP900802-0118.H.txt
D108_AP900802-0118.I.txt
D108_AP900802-0180.H.txt
D108_AP900802-0180.I.txt
D108_AP900803-0008.H.txt
D108_AP900803-0008.I.txt
D108_AP900807-0029.H.txt
D108_AP900807-0029.I.txt
D108_AP900807-0093.H.txt
D108_AP900807-0093.I.txt
D108_AP900808-0030.H.txt
D108_AP900808-0030.I.txt
D108_LA080290-0037.H.txt
D108_LA080290-0037.I.txt
D108_LA080290-0233.H.txt
D108_LA080290-0233.I.txt
D108_LA080690-0111.H.txt
D108_LA080690-0111.I.txt
D108_LA080890-0078.H.txt
D108_LA080890-0078.I.txt
D109_FBIS4-26242.B.txt
D109_FBIS4-26242.J.txt
D109_FBIS4-26245.B.txt
D109_FBIS4-26245.J.txt
D109_FBIS4-26327.B.txt
D109_FBIS4-26327.J.txt
D109_FBIS4-26392.B.txt
D109_FBIS4-26392.J.txt
D109_FBIS4-26516.B.txt
D109_FBIS4-26516.J.txt
D109_FBIS4-26532.B.txt
D109_FBIS4-26532.J.txt
D109_FBIS4-26604.B.txt
D109_FBIS4-26604.J.txt
D109_FBIS4-26614.B.txt
D109_FBIS4-26614.J.txt
D109_FBIS4-26768.B.txt
D109_FBIS4-26768.J.txt
D109_FBIS4-26769.B.txt
D109_FBIS4-26769.J.txt
D110_AP900731-0113.B.txt
D110_AP900731-0113.C.txt
D110_AP900802-0092.B.txt
D110_AP900802-0092.C.txt
D110_AP900802-0135.B.txt
D110_AP900802-0135.C.txt
D110_AP900802-0159.B.txt
D110_AP900802-0159.C.txt
D110_AP900802-0164.B.txt
D110_AP900802-0164.C.txt
D110_AP900802-0180.B.txt
D110_AP900802-0180.C.txt
D110_AP900803-0004.B.txt
D110_AP900803-0004.C.txt
D110_AP900804-0057.B.txt
D110_AP900804-0057.C.txt
D110_AP900804-0067.B.txt
D110_AP900804-0067.C.txt
D110_AP900805-0060.B.txt
D110_AP900805-0060.C.txt
D110_AP900806-0077.B.txt
D110_AP900806-0077.C.txt
D110_AP900806-0095.B.txt
D110_AP900806-0095.C.txt
D110_LA080290-0233.B.txt
D110_LA080290-0233.C.txt
D110_LA080690-0111.B.txt
D110_LA080690-0111.C.txt
D110_WSJ900803-0023.B.txt
D110_WSJ900803-0023.C.txt
D111_AP880521-0088.C.txt
D111_AP880521-0088.F.txt
D111_AP880913-0070.C.txt
D111_AP880913-0070.F.txt
D111_AP890125-0099.C.txt
D111_AP890125-0099.F.txt
D111_AP890201-0043.C.txt
D111_AP890201-0043.F.txt
D111_AP890417-0189.C.txt
D111_AP890417-0189.F.txt
D111_AP890613-0125.C.txt
D111_AP890613-0125.F.txt
D111_AP890622-0157.C.txt
D111_AP890622-0157.F.txt
D111_AP890820-0068.C.txt
D111_AP890820-0068.F.txt
D111_FBIS4-57796.C.txt
D111_FBIS4-57796.F.txt
D111_FT943-178.C.txt
D111_FT943-178.F.txt
D112_FT922-1115.E.txt
D112_FT922-1115.G.txt
D112_FT922-2972.E.txt
D112_FT922-2972.G.txt
D112_FT922-3446.E.txt
D112_FT922-3446.G.txt
D112_FT924-12616.E.txt
D112_FT924-12616.G.txt
D112_FT941-11518.E.txt
D112_FT941-11518.G.txt
D112_FT942-12054.E.txt
D112_FT942-12054.G.txt
D112_LA060590-0086.E.txt
D112_LA060590-0086.G.txt
D112_SJMN91-06311092.E.txt
D112_SJMN91-06311092.G.txt
D112_SJMN91-06346032.E.txt
D112_SJMN91-06346032.G.txt
D112_WSJ910418-0159.E.txt
D112_WSJ910418-0159.G.txt
D113_FT931-2858.A.txt
D113_FT931-2858.I.txt
D113_FT931-2981.A.txt
D113_FT931-2981.I.txt
D113_FT931-3664.A.txt
D113_FT931-3664.I.txt
D113_FT931-3764.A.txt
D113_FT931-3764.I.txt
D113_FT931-4176.A.txt
D113_FT931-4176.I.txt
D114_AP900121-0039.F.txt
D114_AP900121-0039.I.txt
D114_AP900130-0010.F.txt
D114_AP900130-0010.I.txt
D114_AP900208-0116.F.txt
D114_AP900208-0116.I.txt
D114_AP900212-0061.F.txt
D114_AP900212-0061.I.txt
D114_AP900220-0089.F.txt
D114_AP900220-0089.I.txt
D114_AP900224-0094.F.txt
D114_AP900224-0094.I.txt
D114_AP900307-0146.F.txt
D114_AP900307-0146.I.txt
D114_AP900324-0081.F.txt
D114_AP900324-0081.I.txt
D114_AP900330-0086.F.txt
D114_AP900330-0086.I.txt
D114_AP900406-0164.F.txt
D114_AP900406-0164.I.txt
D114_AP900524-0130.F.txt
D114_AP900524-0130.I.txt
D114_AP900625-0090.F.txt
D114_AP900625-0090.I.txt
D114_AP900718-0069.F.txt
D114_AP900718-0069.I.txt
D114_AP900724-0090.F.txt
D114_AP900724-0090.I.txt
D114_AP900821-0092.F.txt
D114_AP900821-0092.I.txt
D115_AP880821-0008.B.txt
D115_AP880821-0008.J.txt
D115_AP880821-0010.B.txt
D115_AP880821-0010.J.txt
D115_AP880822-0075.B.txt
D115_AP880822-0075.J.txt
D115_AP880823-0059.B.txt
D115_AP880823-0059.J.txt
D115_AP880823-0127.B.txt
D115_AP880823-0127.J.txt
D115_AP880824-0050.B.txt
D115_AP880824-0050.J.txt
D115_AP880824-0139.B.txt
D115_AP880824-0139.J.txt
D115_AP880825-0147.B.txt
D115_AP880825-0147.J.txt
D115_AP880826-0161.B.txt
D115_AP880826-0161.J.txt
D116_AP900422-0032.B.txt
D116_AP900422-0032.H.txt
D116_AP900424-0048.B.txt
D116_AP900424-0048.H.txt
D116_AP900424-0096.B.txt
D116_AP900424-0096.H.txt
D116_AP900425-0198.B.txt
D116_AP900425-0198.H.txt
D116_AP900426-0135.B.txt
D116_AP900426-0135.H.txt
D116_AP900428-0022.B.txt
D116_AP900428-0022.H.txt
D116_AP900428-0050.B.txt
D116_AP900428-0050.H.txt
D116_LA042290-0160.B.txt
D116_LA042290-0160.H.txt
D116_LA042590-0135.B.txt
D116_LA042590-0135.H.txt
D116_LA042590-0152.B.txt
D116_LA042590-0152.H.txt
D117_AP881025-0196.C.txt
D117_AP881025-0196.G.txt
D117_AP890922-0224.C.txt
D117_AP890922-0224.G.txt
D117_AP891026-0208.C.txt
D117_AP891026-0208.G.txt
D117_AP901008-0174.C.txt
D117_AP901008-0174.G.txt
D117_AP901016-0112.C.txt
D117_AP901016-0112.G.txt
D117_FT923-3822.C.txt
D117_FT923-3822.G.txt
D117_FT943-3897.C.txt
D117_FT943-3897.G.txt
D117_FT943-5106.C.txt
D117_FT943-5106.G.txt
D117_FT944-16774.C.txt
D117_FT944-16774.G.txt
D117_WSJ871110-0154.C.txt
D117_WSJ871110-0154.G.txt
D118_AP890105-0224.E.txt
D118_AP890105-0224.F.txt
D118_AP890211-0110.E.txt
D118_AP890211-0110.F.txt
D118_AP890228-0146.E.txt
D118_AP890228-0146.F.txt
D118_AP890309-0143.E.txt
D118_AP890309-0143.F.txt
D118_AP890316-0012.E.txt
D118_AP890316-0012.F.txt
D118_LA020189-0050.E.txt
D118_LA020189-0050.F.txt
D118_LA020489-0035.E.txt
D118_LA020489-0035.F.txt
D118_LA021189-0003.E.txt
D118_LA021189-0003.F.txt
D118_SJMN91-06097121.E.txt
D118_SJMN91-06097121.F.txt
D118_WSJ910213-0136.E.txt
D118_WSJ910213-0136.F.txt
D119_AP890517-0106.F.txt
D119_AP890517-0106.H.txt
D119_AP890715-0076.F.txt
D119_AP890715-0076.H.txt
D119_AP890801-0134.F.txt
D119_AP890801-0134.H.txt
D119_AP900102-0114.F.txt
D119_AP900102-0114.H.txt
D119_AP900420-0006.F.txt
D119_AP900420-0006.H.txt
D119_AP900510-0029.F.txt
D119_AP900510-0029.H.txt
D119_FBIS3-13911.F.txt
D119_FBIS3-13911.H.txt
D119_LA020289-0065.F.txt
D119_LA020289-0065.H.txt
D119_LA020389-0041.F.txt
D119_LA020389-0041.H.txt
D119_LA072689-0050.F.txt
D119_LA072689-0050.H.txt
D119_WSJ920203-0038.F.txt
D119_WSJ920203-0038.H.txt
D120_ FT932-15960.J.txt
D120_AP901127-0119.E.txt
D120_AP901127-0119.J.txt
D120_FBIS3-1707.E.txt
D120_FBIS3-1707.J.txt
D120_FBIS4-18298.E.txt
D120_FBIS4-18298.J.txt
D120_FBIS4-24776.E.txt
D120_FBIS4-24776.J.txt
D120_FT932-15960.E.txt
D120_FT933-10917.E.txt
D120_FT933-10917.J.txt
D120_FT942-6613.E.txt
D120_FT942-6613.J.txt
D120_LA112790-0154.E.txt
D120_LA112790-0154.J.txt
D120_LA112890-0036.E.txt
D120_LA112890-0036.J.txt
D120_LA122190-0149.E.txt
D120_LA122190-0149.J.txt
