#!/usr/bin/env perl

use strict;
use warnings;
use Getopt::Long;
use File::Find;
use Cwd qw(realpath);
use Data::Dump qw(dump);
use Statistics::Descriptive;
use Cwd qw(realpath);

my $el = "\n";

dump parseline("AriesAbdelkrim-en-1 ROUGE-1 Average_R: 0.45665 (95%-conf.int. 0.43648 - 0.47496)\n");

sub parseline
{
	my ($line) = @_;
	chomp $line;
	my ($name, $rougeType, $scoreType, $score, undef, $confLeft, undef, $confRight) = split(/ /, $line);
	$scoreType = substr($scoreType, 8, 1);
	substr($confRight, -1, 1) = '';
	my $language = '?';
	my $method   = 0;
	my $user     = '?';
	if ($name =~ m/^([^\-]+).*\-([a-z][a-z])\-(\d)/)
	{
		$user     = $1;
		$language = $2;
		$method   = $3;
	}
	return ($user, $name, $language, $method, $rougeType, $scoreType, $score, undef, $confLeft, undef, $confRight);
}
