#!/usr/bin/env perl

use strict;
use warnings;
use Data::Dump qw(dump);
use File::Slurp;
use File::Basename qw(basename dirname);

# get the number of command line options present.
foreach my $inputFile (@ARGV)
{
  my $text = read_file($inputFile, binmode => ':utf8');
  $text =~ s/[\p{C}\p{Z}]+/ /g;
  $text =~ s/^ +//g;
  $text =~ s/ +$//g;
  my $size = length ($text);
  my $name = basename ($inputFile);
  $name = substr ($name, 0, 32) . '.txt';
  print "$name $size\n";
}

