/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.essex.ofs;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import com.yang.herong.DOMValidator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OFSSubmissionDigest {
    private void digestSubmission(File file, String groupName) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(groupName + file.getName() + ".crwdflwr.csv");
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        PrintWriter pw = new PrintWriter(osw);
        pw.println("id,apiObjectID,comment,statement,argumentLabel,sentimentLabel");
        DOMValidator domValidator = new DOMValidator();
        Document document = null;
        try {
            document = domValidator.validateDocument(file.getName());
        }
        catch (ParserConfigurationException e) {
            System.out.println(e.toString());
            System.out.println("Exitting...");
            System.exit(1);
        }
        catch (SAXException e) {
            System.out.println(e.toString());
            System.out.println("Exitting...");
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.out.println("Exitting...");
            System.exit(1);
        }
        NodeList nl = document.getElementsByTagName("articleText");
        Map<String, String> mapIdToArtSentence = this.mapSentencesAndContext(nl.item(0));
        nl = document.getElementsByTagName("commentaries");
        Map<String, String> mapIdToComSentence = this.mapComments(nl.item(0));
        nl = document.getElementsByTagName("link");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element link = (Element)nl.item(i);
            String idLink = link.getAttribute("id");
            String idComSentence = link.getAttribute("com_sentence");
            String idArtSentence = link.getAttribute("art_sentence");
            NodeList auxList = link.getElementsByTagName("argument");
            String argumentLabel = ((Element)auxList.item(0)).getAttribute("label");
            auxList = link.getElementsByTagName("sentiment");
            String sentimentLabel = ((Element)auxList.item(0)).getAttribute("label");
            if (!mapIdToArtSentence.containsKey(idArtSentence) && !mapIdToComSentence.containsKey(idArtSentence)) {
                System.out.println("Error: art_sentence value in link " + idLink + " points to non-existent sentence id!");
                System.exit(1);
            }
            if (!mapIdToComSentence.containsKey(idComSentence)) {
                System.out.println("Error: com_sentence value in link " + idLink + " points to a sentence which is not part of the commentaries!");
                System.exit(1);
            }
            if (argumentLabel == null) {
                System.out.println("Warning: argument label for link " + idLink + " is null!");
            }
            if (sentimentLabel == null) {
                System.out.println("Warning: sentiment label for link " + idLink + " is null!");
            }
            String comment = mapIdToComSentence.get(idComSentence);
            String statement = "";
            statement = mapIdToComSentence.containsKey(idArtSentence) ? mapIdToComSentence.get(idArtSentence) : mapIdToArtSentence.get(idArtSentence);
            String apiObjectID = "TODO";
            pw.println(i + "," + apiObjectID + "," + comment + "," + statement + "," + argumentLabel + "," + sentimentLabel);
        }
        pw.close();
        osw.close();
        ((OutputStream)bos).close();
        ((OutputStream)fos).close();
    }

    private Map<String, String> mapComments(Node node) {
        HashMap<String, String> mapResult = new HashMap<String, String>();
        Element parent = (Element)node;
        NodeList nl = parent.getElementsByTagName("comment");
        for (int i = 0; i < nl.getLength(); ++i) {
            Map<String, String> mapSentsAndContext = this.mapSentencesAndContext(nl.item(i));
            mapResult.putAll(mapSentsAndContext);
        }
        return mapResult;
    }

    private Map<String, String> mapSentencesAndContext(Node node) {
        HashMap<String, String> mapResult = new HashMap<String, String>();
        String prevPrevId = "";
        String prevPrevSentence = "";
        String prevId = "";
        String prevSentence = "";
        String nextNextId = "";
        String nextNextSentence = "";
        String nextId = "";
        String nextSentence = "";
        Element parent = (Element)node;
        NodeList nl = parent.getElementsByTagName("s");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element sentence = (Element)nl.item(i);
            String id = sentence.getAttribute("id");
            NodeList textNodes = sentence.getChildNodes();
            StringBuffer strBuffer = new StringBuffer();
            for (int j = 0; j < textNodes.getLength(); ++j) {
                strBuffer.append(textNodes.item(j).getNodeValue());
            }
            String currentSentence = strBuffer.toString();
            if (i == 0) {
                nextId = id;
                nextSentence = currentSentence;
                continue;
            }
            if (i == 1) {
                nextNextId = id;
                nextNextSentence = currentSentence;
                continue;
            }
            String focusId = nextId;
            String focusSentence = nextSentence;
            nextId = nextNextId;
            nextSentence = nextNextSentence;
            nextNextId = id;
            nextNextSentence = currentSentence;
            mapResult.put(focusId, prevPrevSentence + prevSentence + "<b>" + focusSentence + "</b>" + nextSentence + nextNextSentence);
            prevPrevId = prevId;
            prevPrevSentence = prevSentence;
            prevId = focusId;
            prevSentence = focusSentence;
        }
        mapResult.put(nextId, prevPrevSentence + prevSentence + "<b>" + nextSentence + "</b>" + nextNextSentence);
        mapResult.put(nextNextId, prevSentence + nextSentence + "<b>" + nextNextSentence + "</b>");
        return mapResult;
    }

    public static void main(String[] args) throws JSAPException, FileNotFoundException, IOException {
        SimpleJSAP jsap = new SimpleJSAP("OFSSubmissionDigest", "Validates and digests system submissions to OnForumS, an evaluation campaign for online forum summarization in multiple languages, a pilot track within MultiLing 2015.", new Parameter[]{new UnflaggedOption("input file/directory", (StringParser)JSAP.STRING_PARSER, true, "The input file or directory name for processing (if directory, all files ending in .ofs.out.xml within will be processed)."), new UnflaggedOption("participating group name", (StringParser)JSAP.STRING_PARSER, false, "The name or acronym of the participating group.")});
        JSAPResult config = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        System.out.println("Validating submission... ");
        String path = config.getString("input file/directory");
        String groupName = config.getString("participating group name") + "-";
        if (groupName.startsWith("null")) {
            groupName = "-";
        }
        File[] files = new File[1];
        File input = new File(path);
        if (input.isDirectory()) {
            files = input.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("ofs.out.xml");
                }
            });
        } else {
            files[0] = input;
        }
        OFSSubmissionDigest ofssd = new OFSSubmissionDigest();
        for (int i = 0; i < files.length; ++i) {
            ofssd.digestSubmission(files[i], groupName);
            System.out.println("\t> File " + files[i].getName() + " successfully validated!");
        }
    }
}

